<?php

class CallcenterinvoiceController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
         public function allowedActions() {
            return 'checkinvo';
        }
        public static function setautostatus($abt,$claim_id,$msg=null)
        {
            //echo $abt;
                 $q=new CDbCriteria;
                 $q->compare('t.ability_id',$abt);
                 $a=new AutoStatus;
                 $auto=$a->find($q);
              //var_dump($auto); die();
                if($auto!=null){
                    
                     if($auto->ability_id==ltrim(rtrim($abt)))
                     {
                
                            //$results->select('status')->from('ability');
                            //$results->where('id=:mid', array(':mid'=>(int)$abt));
                         $ab=new AbilityPermission;
                
                            $results =$ab->get_abt($abt); //$results->queryAll();
                
                            $q=new CDbCriteria;
                            $q->select="t.claim_no";
                            $q->compare('t.id',$claim_id);
                            $ck=new Claim;
                            $ckf=$ck->find($q);
                            $us=  UserController::getMe(Yii::app()->user->id);
            
                            
                         $sta=new Statusofclaim;
                         $sta->claim_id=$claim_id;
                         if($abt==2)
                             $s=$us." ".$results->status.":".$ckf->claim_no;
                         else if($abt==13)
                              $s=$us." has created ".$results->status." on Claim:".$ckf->claim_no;
                          else if($abt==15 || $abt==17 || $abt==19 || $abt==20 || $abt==21 || $abt==31
                                  || $abt==32 || $abt==33 || $abt==34 || $abt==35 || $abt=36
                                  || $abt==37 || $abt==38 || $abt==41 || $abt==49 || $abt==51
                                  || $abt==52 || $abt==58 || $abt==61 || $abt==63 || $abt==64 || $abt==80 || $abt==82 || $abt==87 || $abt=89)
                              $s=$us." ".$results->status.":".$ckf->claim_no;
                          else if($abt==39)
                              $s=$results->status.":".$ckf->claim_no." from ".$us;
                          else if($abt==40)
                              $s=$us." ".$results->status.":".$ckf->claim_no." Completed ";
                           else if($abt==44)
                              $s=$us." ".$results->status.":".$ckf->claim_no." to IA ";
                           else if($abt==47)
                              $s=$us." ".$results->status.":".$ckf->claim_no." to Reviewed ";
                           else if($abt==54)
                              $s=$us." ".$results->status.":".$ckf->claim_no." Back to Unassigned ";
                            else if($abt==55)
                              $s=$us." ".$results->status.":".$ckf->claim_no." Reinspected ";
                            else if($abt==60)
                              $s=$us." ".$results->status.":".$ckf->claim_no." to Estimator ";
                            else if($abt==68)
                              $s=$us." ".$results->status.":".$ckf->claim_no." Pending Insurance Appproval ";
                            else if($abt==69)
                              $s=$us." ".$results->status.":".$ckf->claim_no." for Pending Teardown ";
                             else if($abt==70)
                              $s=$us." ".$results->status.":".$ckf->claim_no." for Pending Supplement Approval ";
                              else if($abt==71)
                              $s=$us." ".$results->status.":".$ckf->claim_no." for Parts Ordered ";
                              else if($abt==72)
                              $s=$us." ".$results->status.":".$ckf->claim_no." for In Repair Process";
                               else if($abt==73)
                              $s=$us." ".$results->status.":".$ckf->claim_no." to Repair & Paint Personnel";
                               else if($abt==75)
                              $s=$us." ".$results->status.":".$ckf->claim_no." Scheduled for Re-Assembly";
                               else if($abt==76)
                              $s=$us." ".$results->status.":".$ckf->claim_no." Ready for Delivery";
                         else
                             $s="Claim Number:".$ckf->claim_no." ".$results->status. " ".$us;
                         if($msg!=null)
                             $s=$msg;
                          $s.="<div>".$auto->status_id."</div>";
                       // die();
                         $sta->status=$s;
                         $sta->status_num=$auto->status_id;
                         $sta->created_by=Yii::app()->user->id;
                         $sta->save();
                     }
                }
        }
        public function actionCheckinvo()
        {
             $mode=new Callcenterinvoice;
                    $c = new CDbCriteria;
                $c->compare('t.claim_id',$_REQUEST['Claim_id']);
                $df = $mode->find($c);
                 if($df==null)
                     echo 0;
                 else
                 echo 1;
        }
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id=null)
	{
            $mode=new Callcenterinvoice;
            $c = new CDbCriteria;
                $c->compare('claim_id',$_REQUEST['Claim_id']);
                $df = $mode->find($c);
                 if($df===null)
		{	throw new CHttpException(404,'No Invoices have been created at this time.');
                    return $df;
                }
                $claimid=$df->claim_id;
                        $claim=new Claim;        
                          $q=new CDbCriteria;
                         $q->compare("t.id",$claimid);
                       
                         $claims=$claim->find($q);
                          $output=$this->renderPartial('html',array(
			'data'=>$this->loadModel($df->id),
                        'claims'=>$claims,
		),true);
                if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/callcenter/'.$claimid.'callcenter-invoice-.pdf'))
                    unlink (dirname(dirname(dirname(__FILE__))).'/invoice/callcenter/'.$claimid.'callcenter-invoice-.pdf');
                 $html2pdf = Yii::app()->ePdf->HTML2PDF();
                 $html2pdf = Yii::app()->ePdf->HTML2PDF('P', 'A2');
                    $html2pdf->WriteHTML($output);
                
                    $html2pdf->Output(dirname(dirname(dirname(__FILE__))).'/invoice/callcenter/'.$claimid.'callcenter-invoice-.pdf', EYiiPdf::OUTPUT_TO_FILE);
           
		$this->render('view',array(
			'data'=>$this->loadModel($df->id),
                        'claims'=>$claims,
		));
	}
public  function ispaids($status)
        {
            
            switch ($status)
            {
                case 0:
                return "No";
                 break;
                case 1:
                  return "Yes";
                 break;
              
                
            }
                
            
        }
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Callcenterinvoice;
                $mode=new Callcenterinvoice;
                    $c = new CDbCriteria;
                $c->compare('claim_id',$_REQUEST['Claim_id']);
                $df = $mode->find($c);
                //$model = $this->loadModel($df->id,'Cfsinvoice');
                    if($df)
                    {
                       // $this->actionEdit($_REQUEST['Claim_id']);
                        $this->redirect(array('update','id'=>$df->id,'abt'=>$_POST['ability']));
                        //exit();
                    }
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Callcenterinvoice']))
		{
			$model->attributes=$_POST['Callcenterinvoice'];
                         $model->paid_date=$_POST['Callcenterinvoice']['paid_date'];
			if($model->save())
                        {	
                            $this->setautostatus($_POST['ability'],$_REQUEST['Claim_id']);
                            $this->redirect(array('view','Claim_id'=>$model->claim_id));}
                        }
                    $claimid=$_REQUEST['Claim_id'];
                         $claim=new Claim;        
                         $q=new CDbCriteria;
                         $q->compare("t.id",$claimid);
                       
                         $claims=$claim->find($q);
		$this->render('create',array(
			'model'=>$model,
                     'claims'=>$claims,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                    $claimid=$model->claim_id;
                        $claim=new Claim;        
                          $q=new CDbCriteria;
                         $q->compare("t.id",$claimid);
                       
                         $claims=$claim->find($q);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Callcenterinvoice']))
		{
			$model->attributes=$_POST['Callcenterinvoice'];
                         $model->paid_date=$_POST['Callcenterinvoice']['paid_date'];
			if($model->save())
                        {	
                           // echo $_REQUEST['abt'];
                            $this->setautostatus($_REQUEST['abt'],$claimid);
                            $this->redirect(array('view','Claim_id'=>$model->claim_id));
                        
                        }
		}

		$this->render('update',array(
			'model'=>$model,
                        'claims'=>$claims,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Callcenterinvoice');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Callcenterinvoice('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Callcenterinvoice']))
			$model->attributes=$_GET['Callcenterinvoice'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Callcenterinvoice the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Callcenterinvoice::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'No Invoices have been created at this time.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Callcenterinvoice $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='callcenterinvoice-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
