<?php

class BranchController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights'
		);
	}


/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
public function actionBranchdisplay()
{
     $uid=Yii::app()->user->id;
                $mod=User::model()->findByPk($uid);
                $id=$mod->branch_id;
    $this->render('view',array(
			'model'=>$this->loadModel($id),
                        
		));
}
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
        public function actionViewbranch($id=null)
	{
            if($id==null)
            {
                $uid=Yii::app()->user->id;
                $mod=User::model()->findByPk($uid);
                $id=$mod->branch_id;
                
            }
            $md=new User;
            $q=new CDbCriteria;
            $q->compare('t.branch_id',$id);
            $umod=$md->findAll($q);
            $type=new Authitem;
                $q=new CDbCriteria;
                $q->compare('t.type','2');
                $types=$type->findAll($q);
		$this->render('_viewbranch',array(
			'data'=>$this->loadModel($id),
                        'id'=>$id,
                       'row'=>$umod,
                    'types'=>$types,
		));
	}
        public function actionViewbranchdetail($id=null)// view for view company branch and users
	{
            if($id==null)
            {
                $uid=Yii::app()->user->id;
                $mod=User::model()->findByPk($uid);
                $id=$mod->branch_id;
                
            }
               $model=$this->loadModel($id);
                $usr=new User;
            $q=new CDbCriteria;
            $q->compare('t.branch_id',$id);
                   $dataProvider= new CActiveDataProvider($usr, array(
			'criteria'=>$q,
                            'pagination' => array(
                            'pageSize' => 10,
                        ),));
		$this->render('_viewdetail',array(
			'data'=>$model,
                        'usr'=>$usr,
                        'row'=>$dataProvider,
		));
	}
	public function actionView($id=null)
	{
            /*if($id==null)
            {
               $m= UserController::getUserDetail(Yii::app()->user->id);
                $id=$m->branch_id;//Yii::app()->user->branch_id;
                
            }
            
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));*/
            
            if($id==null)
            {
                $uid=Yii::app()->user->id;
                $mod=User::model()->findByPk($uid);
                $id=$mod->branch_id;
                
            }
            $md=new User;
            $q=new CDbCriteria;
            $q->compare('t.branch_id','='.$id);
            $umod=$md->findAll($q);
            $type=new Authitem;
                $q=new CDbCriteria;
                $q->compare('t.type','2');
                $types=$type->findAll($q);
                $zip=new ZipCoverage;
                $q=new CDbCriteria;
                $q->compare('t.branch_id',$id);
                $zipcs=$zip->findAll($q);
		$this->render('_viewbranch',array(
			'data'=>$this->loadModel($id),
                        'id'=>$id,
                       'row'=>$umod,
                    'types'=>$types,
                    'zipcs'=>$zipcs,
		));
	}
         public function allowedActions()
        { 
            return 'Get_tpa_adjusterdetail,getCmp,coveragedelete,Getdetail,Getadjuster,Gettpaadjuster,Getadjusterdetail,getdetail,getadjuster,gettpaadjuster,getadjusterdetail';
        }
        public function actiongetCmp()
        {
            $q=new CDbCriteria;
            $q->select="t.company_id";
            $q->compare("t.id",$_REQUEST['User']['branch_id']);
            $br=new Branch;
            $bchs=$br->find($q);
            $cmp_id=$bchs->company_id;
            $typ = new Company;
                $c = new CDbCriteria;
		$c->select='t.id,t.name';
                //$c->join = 'left join branch on branch.company_id=t.id';
                $c->compare('t.id',$cmp_id); 
                $c->order="t.name";
                $data = $typ->findAll($c);
		//var_dump($data);		
                $data=CHtml::listData($data,'id','name');                
               // echo CHtml::tag('option',
                //               array('value'=>''),'Select',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
        public function actionGetdetail()
        {
              
              //  $model=new Branch;
              $type_id=  UserController::getTypeid(Yii::app()->user->id); 
           if($type_id<=5 || $type_id==50 || ($type_id>=18 && $type_id<=26))  
           {  
                 
             $sql= 'SELECT * from branch where id=:brch';
               
                $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid']));
            
           }
           else
           {  
                 
             $sql= 'SELECT * from child_branch where id=:brch';
               
                $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid']));
            
           }
            echo CJSON::encode($rs);
            Yii::app()->end();
        }
        public function actionGetadjuster()
        {
            $type_id=  UserController::getTypeid(Yii::app()->user->id);
             
                  
             $usr = new User;
              if($type_id<=5 || $type_id==50 || $type_id==21)
              {
                  
             $sql= 'SELECT t.id,t.first_name,t.last_name FROM user t left join authassignment on authassignment.userid=t.id '
                     . 'WHERE t.branch_id = :brch and authassignment.itemname=:type  order by t.first_name,t.last_name';
             $type = '19';
               if($type_id==21)
                $type = '19';//and  authassignment.itemname = :type
                $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid'],':type'=>$type));
              }
              else
              {
                  $sql="select t.id,t.first_name,t.last_name FROM child_aduster t where t.branch_id = :brch";
                  $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid']));
                /*  $array1=array(
                      array('id'=>'Addnew','first_name'=>'Add','last_name'=>'New'));
                  $data=  array_merge($array1,$data);*/
              }
        
 
             // var_dump($data);
                echo CJSON::encode($data);
                    Yii::app()->end();
				
        }
         public function actionGettpaadjuster()
        {
             $type_id=  UserController::getTypeid(Yii::app()->user->id);
             
                  
             $usr = new User;
              if($type_id<=5 || $type_id==50)
              {
             
             $sql= 'SELECT t.id,t.first_name,t.last_name FROM user t left join authassignment on authassignment.userid=t.id '
                     . 'WHERE t.branch_id = :brch and authassignment.itemname=:type  order by t.first_name,t.last_name';
                $type = '27';//and  authassignment.itemname = :type)
        $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid'],':type'=>$type));
              }
               else
              {
                  $sql="select t.id,t.first_name,t.last_name FROM child_aduster t where t.branch_id = :brch";
                  $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['branchid']));
                /*  $array1=array(
                      array('id'=>'Addnew','first_name'=>'Add','last_name'=>'New'));
                  $data=  array_merge($array1,$data);*/
              } 
                echo CJSON::encode($data);
                    Yii::app()->end();
				
        }
        public function actionGet_tpa_adjusterdetail()
        {
            
            $type_id=  UserController::getTypeid(Yii::app()->user->id);
           if(($type_id<=5 || $type_id==50) || ($type_id>=27 && $type_id<=32))
           {  //$rs=User::model()->findByPk($_POST['uid']); 
            $sql="select * FROM user t left join useraddress "
                    . " on useraddress.user_id=t.id where t.id = :brch";
                  $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['uid']));
         
           }
           else
           {//$rs=  Childaduster::model()->findByPk($_POST['uid']);
           $sql="select t.id,t.first_name,t.last_name,t.email,t.workphone,child_address.office_fax FROM child_aduster t left join child_address"
                    . " on child_address.user_id=t.id where t.id = :brch";
                  $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['uid']));
           }
            echo CJSON::encode($rs);
            Yii::app()->end();
        }
        public function actionGetadjusterdetail()
        {
            $type_id=  UserController::getTypeid(Yii::app()->user->id);
           if(($type_id<=5 || $type_id==50) || ($type_id>=18 && $type_id<=26))
           {   //$rs=User::model()->findByPk($_POST['uid']);
                $sql="select * FROM user t left join useraddress "
                    . " on useraddress.user_id=t.id where t.id = :brch";
                  $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['uid']));
           } 
           else
           {//$rs=  Childaduster::model()->findByPk($_POST['uid']);
           $sql="select t.id,t.first_name,t.last_name,t.email,t.workphone,child_address.office_fax FROM child_aduster t left join child_address"
                    . " on child_address.user_id=t.id where t.id = :brch";
                  $rs= Yii::app()->db->createCommand($sql)->queryAll(true,array(':brch'=>$_POST['uid']));
           }
            echo CJSON::encode($rs);
            Yii::app()->end();
        }
        
        public function actionEditzipcoverage()
        {}
        public function actionBranchcoverage()
        {
            $model=new Branch;
           // $c=new CdbCriteria;
           
            if(isset($_POST['zipcoverage']))
            {
                $size=count($_POST['zipcoverage']);
                 for($i=0;$i<$size;$i++)
                  { 
                      Branch::model()->updateAll(array('zipcodecoverage'=>$_POST['zipcoverage'][$i]), 'id='.$_POST['id'][$i]) ;
                  
                        Yii::app()->user->setFlash('success','Zip Coverage saved Successfully');
                         
                  }
            }
             $m=$model->findAll();
		$this->render('branchcoverage',array(
			'dataProvider'=>$m,
                        'model'=>$model,
                
		));       
        }
        public  function actionCoveragedelete()
        {
            if($_POST['id']!='')
            {
                 Branch::model()->updateAll(array('zipcodecoverage'=>''), 'id='.$_POST['id']) ;
                 return true;
          
            }
        }
        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
         public function actionTopcreate()
        {
             $this->redirect(array('create'));
        }
        public function actionBottomcreate()
        {
             $this->redirect(array('create'));
        }
	public function actionCreate()
	{
		$model=new Branch;
		$cmp=new Company;
                $zip=new ZipCoverage;
                $utype=  UserController::getTypeid(Yii::app()->user->id);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                    $uid=  Yii::app()->user->id;
                    //$rs          = User::model()->findByPk($uid);
                   if($utype>5 && $utype!=50)
                   {
                    $q=new CDbCriteria;
                    $q->select='t.id,t.name,t.type_id';
                    $q->join='left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                    $q->compare('user.id',$uid);
                     $q->order="t.name";
                     $companies=array();
                      if($utype==12 || $utype==21 || $utype==29 || $utype==37 || $utype==46)
                      {
                           $q->select='t.id,t.name,t.type_id';
                           $q->join=' left join user on user.company_id=t.id';
                           $q->compare('user.id',$uid);
                           $q->order="t.name";
                             
                             $companies=$cmp->findAll($q);
                             $cc=$cmp->find($q);
                      }
                    
					$cc=$cmp->find($q);
                   }
                                       // var_dump($cc);
					//echo $cc->type_id;
					// if($cc->type_id<=6)
                                       //  {
                                           //  $q=new CDbCriteria;
                                            // $q->order="t.name";
                                            // $companies=$cmp->findAll($q);
                                         
                                        // }
				    // else
                       // $companies=$cmp->findAll($q,array('id','name'));
                   // var_dump($companies);
                   // echo $cc->type_id;
                  $type=new Companytype;
                  $q=new CDbCriteria;
                  $q->condition='t.id='.$cc->type_id." and t.id!=2 and t.id!=6";
                  
                   $type_id=  UserController::getTypeid(Yii::app()->user->id);
            
            $q->order="t.type";
				  if($utype<=5 || $utype==50)
                                  {
                                      $c=new CDbCriteria;
                                      $c->condition="t.id!=2 and t.id!=6";
                                      $c->order="t.type";
					$types=$type->findAll($c);
                                  }
					else
						$types=$type->findAll($q,array('id','type'));
                
				//$ctype=$type->find($q);
               $roles=Rights::getAssignedRoles(Yii::app()->user->id);
               
                if($utype<=5 || $utype==50)
                {
                    $q=new CDbCriteria;
                    $q->select='t.id,t.name,t.type_id';
                     $q->compare('t.type_id',$ctype->id);
                    $companies=$cmp->findAll($q,array('id','name'));
                }
		if(isset($_POST['Branch']))
		{
			$model->attributes=$_POST['Branch'];
                        $model->aftermiles=$_POST['Branch']['aftermiles'];
                         if($_POST['Company']['type_id']==7)
                             $model->branch_type=$_POST['Branch']['branch_type'];
                         else
                             $model->branch_type='';
                        if($model->validate())
                        {
                            if($_POST['Company']['type_id']!='')
                            {
                                if($model->save())
                                {    
                                    
                                     if(count($_POST['zip'])>0)
                                    {
                                         $i=0;
                                        foreach ($_POST['zip'] as $zc)
                                        {
                                            $zp=new ZipCoverage;
                                            $zp->branch_id=$model->id;
                                            $zp->zipcode=$zc;
                                             $zp->fromzip=$_POST['fromzip'][$i];
                                              $zp->tozip=$_POST['tozip'][$i];
                                            if($zp->validate())
                                            $zp->save();
                                            $i++;
                                        }
                                    }
                                    Yii::app()->user->setFlash('success','Branch successfully created.'); 
                               }
				//$this->redirect(array('view','id'=>$model->id));
                            }
                        }
		}
		
		 $q=new CDbCriteria;
		$stt=new State;
		$states=$stt->findAll('',array('id','name'));
		$this->render('create',array(
			'model'=>$model,
			'type'=>$type,
			'types'=>$types,
			'companies'=>$companies,
			'cmp'=>$cmp,
			'states'=>$states,
                        'zip'=>$zip,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                $zip=new ZipCoverage;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
 
		$cmp=new Company;
                $utype=  UserController::getTypeid(Yii::app()->user->id);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                    $uid=  Yii::app()->user->id;
                    //$rs          = User::model()->findByPk($uid);
                    $q=new CDbCriteria;
                    $q->select='t.id,t.name,t.type_id';
                    $q->join='left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                    $q->compare('user.id',$uid);
                    $companies=$cmp->findAll($q,array('id','name'));
                    // $companies=array();
                      if($utype==12 || $utype==21 || $utype==29 || $utype==37 || $utype==46)
                      {
                           $q->select='t.id,t.name,t.type_id';
                            $q->join=' left join user on user.company_id=t.id';
                            $q->compare('user.id',$uid);
                             $q->order="t.name";
                             
                             $companies=$cmp->findAll($q);
                      }
                    $cc=$cmp->find($q);
                   // echo $cc->type_id;
                  $type=new Companytype;
                  $q=new CDbCriteria;
                 // $q->compare('t.id',$cc->type_id);
                  $q->condition='t.id='.$cc->type_id." and t.id!=2 and t.id!=6";
                  if($utype<=5 || $utype==50)
                      $q->condition="t.id!=2 and t.id!=6";
		$types=$type->findAll($q,array('id','type'));
                $ctype=$type->find($q);
               $roles=Rights::getAssignedRoles(Yii::app()->user->id);
               
               
		if(isset($_POST['Branch']))
		{
			$model->attributes=$_POST['Branch'];
                        $model->aftermiles=$_POST['Branch']['aftermiles'];
                         if($_POST['Company']['type_id']==7)
                             $model->branch_type=$_POST['Branch']['branch_type'];
                         else
                             $model->branch_type='';
                        if($model->validate())
                        {
                            
                                if($model->save())
                                {
                                    if(count($_POST['zip'])>0)
                                    {
                                        $i=0;
                                        foreach ($_POST['zip'] as $zc)
                                        {
                                           // echo $_POST['id'][$i]."-";
                                            if($_POST['id'][$i]!="")
                                                $zp=  ZipCoverage::model ()->findByPk($_POST['id'][$i]);
                                            else
                                                $zp=new ZipCoverage;
                                            $zp->branch_id=$id;
                                            $zp->zipcode=$zc;
                                             $zp->fromzip=$_POST['fromzip'][$i];
                                              $zp->tozip=$_POST['tozip'][$i];
                                            if($zp->validate())
                                            $zp->save();
                                            $i++;
                                        }
                                    }
				$this->redirect(array('view','id'=>$model->id));
                                }
                        }
		}
                $q=new CDbCriteria;
                $q->compare('t.branch_id',$id);
		$zipcs=$zip->findAll($q);
		 $q=new CDbCriteria;
		$stt=new State;
		$states=$stt->findAll('',array('id','name'));
		$this->render('update',array(
			'model'=>$model,
			'type'=>$type,
			'types'=>$types,
			'companies'=>$companies,
			'cmp'=>$cmp,
			'states'=>$states,
                        'zip'=>$zip,
                        'zipcs'=>$zipcs,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Branch');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Branch('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Branch']))
			$model->attributes=$_GET['Branch'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Branch the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Branch::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Branch $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='branch-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
