<?php

class AuthorizationformController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id=null)
	{
                $claim_id=$_REQUEST['Claim_id'];
              // die();
                $mod=new Authorizationform;
                $q=new CDbCriteria;
                $q->compare('t.claim_id',$claim_id);
                $m=$mod->find($q);
                
                $auth_item=new AuthorizationItem;
                 $q=new CDbCriteria;
                $q->compare('t.auth_form_id',$m->id);
                $ims=$auth_item->findAll($q);
                 $auth_text=new Authorizationtext;
                            $q=new CDbCriteria;
                            $q->compare('t.auth_form_id',$id);
                            $at=$auth_text->find($q);
                            if($at!=null)
                                $auth_text=  Authorizationtext::model()->findByPk($at->id);
                    
		$this->render('view',array(
			'model'=>$this->loadModel($m->id),
                        'ims'=>$ims,
                    'auth_text'=>$auth_text,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Authorizationform;
                $claim_id=$_REQUEST['Claim_id'];
                $q=new CDbCriteria;
                $q->compare('t.claim_id',$claim_id);
                $am=$model->find($q);
                if($am!=null)
                    $this->redirect(array('update','id'=>$am->id,'Claim_id'=>$claim_id,'abt'=>$_POST['ability']));
                $ass=new Assignee;
                $q=new CDbCriteria;
                $q->select='t.branch_id';
                $q->join=' left join branch on branch.id=t.branch_id left join company on company.id=branch.company_id'
                        . ' left join companytype on companytype.id=company.type_id';
                $q->condition='company.type_id=3 and t.claim_id='.$claim_id ;
                $assignee=$ass->find($q);
                $bodyshop=array();
                if($assignee!=null)
                {
                    $branchid=$assignee->branch_id;
                    $br=new Branch;
                    $q=new CDbCriteria;
                    $q->compare('t.id',$branchid);
                    $bodyshop=$br->find($q);
                }
                $q=new CDbCriteria;
                $q->select='t.whoose_claim,t.i_first_name,t.i_last_name,o_first_name,o_last_name,'
                        . 't.o_address1,t.o_city,t.o_state_id,t.o_zip,t.o_home,t.claim_no,t.policy_no,t.insurance_company,'
                        . 't.v_year,t.v_make_id,t.v_model_id,t.v_color,t.adi_driver_licence,t.v_milege,t.v_vin,t.v_drivable';
                $q->compare('t.id',$claim_id);
                $c=new Claim;
                $claim=$c->find($q);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                    $auth_item=new AuthorizationItem;
                      $auth_text=new Authorizationtext;      
		if(isset($_POST['Authorizationform']))
		{
			$model->attributes=$_POST['Authorizationform'];
                        $model->claim_id=$_REQUEST['Claim_id'];
                        $model->oral_phone=$_POST['Authorizationform']['oral_phone'];
                        $model->sup_phone=$_POST['Authorizationform']['sup_phone'];
			if($model->save())
                        {	
                            $cm=Claim::model()->findByPk($_REQUEST['Claim_id']);
                            $cm->attributes=$_POST['Claim'];
                            $cm->save();
                            
                            $atext=new Authorizationtext;
                            $atext->attributes=$_POST['Authorizationtext'];
                            $atext->auth_form_id=$model->id;
                            $atext->save();
                            $size=count($_POST['item']);
                            for($i=0;$i<$size;$i++)
                            {
                                $ai=new AuthorizationItem;
                                $ai->auth_form_id=$model->id;
                                $ai->item=$_POST['item'][$i];
                                $ai->type=$_POST['type'][$i];
                                $ai->part_price=$_POST['part_price'][$i];
                                $ai->labour=$_POST['labour'][$i];
                                if($ai->validate())
                                   $ai->save();
                                   //
                              }
                            }
                            $us=  UserController::getMe(Yii::app()->user->id);
            
                            $msg=$us." has Created/Edited Repair Authorization Form for Claim: ".$claim->claim_no;
                             CallcenterinvoiceController::setautostatus(56,$claim_id,$msg);
                            $this->redirect(array('view','id'=>$model->id));
                        
                   }
		
                 $count = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('authorization_form')
                                ->queryScalar();
                         $count=$count+1;
                         $state=new State;
                         $q=new CDbCriteria;
                         $q->order='name ASC';
                         $states=$state->findAll($q,array('id','name'));
                        $q=new CDbCriteria;
                        $sql= 'SELECT id,name FROM company WHERE type_id LIKE :type1  order by name';

                        $cmpp= Yii::app()->db->createCommand($sql)->queryAll(true,array(':type1'=>1));
                        $branch = new Branch; 
                         $make=new Vehiclemake;
                            $q=new CDbCriteria;
                            $q->order='make_name ASC';
                            $makes=$make->findAll($q,array('id','make_name'));
                            $mdl=new Vehiclemodel;
                            $q=new CDbCriteria;
                            $q->order='model ASC';
                            $models=$mdl->findAll($q,array('id','model'));
		$this->render('create',array(
			'model'=>$model,
                        'bodyshop'=>$bodyshop,
                        'claim'=>$claim,
                        'auth_item'=>$auth_item,
                        'count'=>$count,
                        'state'=>$states,
                        'ins'=>$cmpp,
                        'branch'=>$branch,
                        'makes'=>$makes,
                        'models'=>$models,
                        'auth_text'=>$auth_text,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                 $claim_id=$model->claim_id;
                $ass=new Assignee;
                $q=new CDbCriteria;
                $q->select='t.branch_id';
                $q->join=' left join branch on branch.id=t.branch_id left join company on company.id=branch.company_id'
                        . ' left join companytype on companytype.id=company.type_id';
                $q->condition='company.type_id=3 and t.claim_id='.$claim_id ;
                $assignee=$ass->find($q);
                $bodyshop=array();
                if($assignee!=null)
                {
                    $branchid=$assignee->branch_id;
                    $br=new Branch;
                    $q=new CDbCriteria;
                    $q->compare('t.id',$branchid);
                    $bodyshop=$br->find($q);
                }
                $q=new CDbCriteria;
                $q->select='t.whoose_claim,t.i_first_name,t.i_last_name,o_first_name,o_last_name,'
                        . 't.o_address1,t.o_city,t.o_state_id,t.o_zip,t.o_home,t.claim_no,t.policy_no,t.insurance_company,'
                        . 't.v_year,t.v_make_id,t.v_model_id,t.v_color,t.adi_driver_licence,t.v_milege,t.v_vin,t.v_drivable';
                $q->compare('t.id',$claim_id);
                $c=new Claim;
                $claim=$c->find($q);
               
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                    $auth_item=new AuthorizationItem;
                    $auth_text=new Authorizationtext;   
                           
		if(isset($_POST['Authorizationform']))
		{
			$model->attributes=$_POST['Authorizationform'];
                        $model->claim_id=$_REQUEST['Claim_id'];
                        $model->oral_phone=$_POST['Authorizationform']['oral_phone'];
                        $model->sup_phone=$_POST['Authorizationform']['sup_phone'];
			if($model->save())
                        {	
                            
                            $cm=Claim::model()->findByPk($claim_id);
                            $cm->attributes=$_POST['Claim'];
                            $cm->save();
                            
                            $atext=new Authorizationtext;
                            $q=new CDbCriteria;
                            $q->compare('t.auth_form_id',$model->id);
                            $at=$atext->find($q);
                            if($at!=null)
                                $atext=  Authorizationtext::model()->findByPk($at->id);
                            $atext->attributes=$_POST['Authorizationtext'];
                            $atext->auth_form_id=$model->id;
                            $atext->save();
                            $size=count($_POST['item']);
                            for($i=0;$i<$size;$i++)
                            {
                                $ai=new AuthorizationItem;
                                if($_POST['authitem-id'][$i]!='')
                                {
                                    $ai=  AuthorizationItem::model()->findByPk($_POST['authitem-id'][$i]);
                                }
                                $ai->auth_form_id=$model->id;
                                $ai->item=$_POST['item'][$i];
                                $ai->type=$_POST['type'][$i];
                                $ai->part_price=$_POST['part_price'][$i];
                                $ai->labour=$_POST['labour'][$i];
                                if($ai->validate())
                                   $ai->save();
                                   //
                              }
                            }
                            $us=  UserController::getMe(Yii::app()->user->id);
            
                            $msg=$us." has Created/Edited Repair Authorization Form for Claim: ".$claim->claim_no;
                             CallcenterinvoiceController::setautostatus(56,$claim_id,$msg);
                            $this->redirect(array('view','id'=>$model->id));
                        
                   }
		 
                $q=new CDbCriteria;
                $q->compare('t.auth_form_id',$id);
                $ims=$auth_item->findAll($q);
                 $count = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('authorization_form')
                                ->queryScalar();
                         $count=$count+1;
                         $state=new State;
                 $q=new CDbCriteria;
                 $q->order='name ASC';
		$states=$state->findAll($q,array('id','name'));
                $make=new Vehiclemake;
                 $q=new CDbCriteria;
                            $q->order='make_name ASC';
                            $makes=$make->findAll($q,array('id','make_name'));
                            $mdl=new Vehiclemodel;
                            $q=new CDbCriteria;
                            $q->order='model ASC';
                            $models=$mdl->findAll($q,array('id','model'));
                      $q=new CDbCriteria;
                        $sql= 'SELECT id,name FROM company WHERE type_id LIKE :type1  order by name';

                        $cmpp= Yii::app()->db->createCommand($sql)->queryAll(true,array(':type1'=>1)); 
                        
                        $atext=new Authorizationtext;
                            $q=new CDbCriteria;
                            $q->compare('t.auth_form_id',$id);
                            $at=$atext->find($q);
                            if($at!=null)
                                $auth_text=  Authorizationtext::model()->findByPk($at->id);
                    
		$this->render('update',array(
			'model'=>$model,
                        'bodyshop'=>$bodyshop,
                        'claim'=>$claim,
                        'auth_item'=>$auth_item,
                        'count'=>$count,
                        'ims'=>$ims,
                        'state'=>$states,
                        'makes'=>$makes,
                        'models'=>$models,
                        'auth_text'=>$auth_text,
                        'ins'=>$cmpp,
		));

		 
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Authorizationform');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Authorizationform('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Authorizationform']))
			$model->attributes=$_GET['Authorizationform'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Authorizationform the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Authorizationform::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Authorizationform $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='authorizationform-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
