<?php

class AdjstersupervisingController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
            $model=Adjstersupervising::model()->findAll();
            
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
        public function allowedActions() {
            return 'setsupervisors,unsetsupervisors';
        }

        public function actionSetsupervisors()
        {
            if($_POST['supid']!='')
            {
                 $model=new Adjstersupervising;
                $criteria=new CDbCriteria;
                $criteria->compare('t.adjuster_id',$_POST['adjid']);
                //$criteria->compare('t.superwiser_id',$_POST['supid']);
                $m=$model->find($criteria);
                if ($m==null)
                {   $model->adjuster_id=$_POST['adjid'];
                      $model->superwiser_id=$_POST['supid'];
                      $model->created_by=Yii::app()->user->id;
                      $model->save();
                }
                else if($m->superwiser_id!=$_POST['supid']) {
                     Adjstersupervising::model()->updateAll(array('superwiser_id'=>$_POST['supid']), 'adjuster_id='.$_POST['adjid']) ;
            
                }
                
            }
            
        }
        
        public function actionUnSetsupervisors()
        {
            if($_POST['supid']!='')
            {
                // Adjstersupervising::model()->deleteAll(array("condition"=>"adjuster_id=".$_POST['adjid']." and superwiser_id=".$_POST['supid']));
          
            }
            
        }

        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Adjstersupervising;
                $type_id=  UserController::getTypeid(Yii::app()->user->id);
                $udetail=  UserController::getUserDetail(Yii::app()->user->id);
                $cmp=$udetail->branch->company->id;
                $bran=new Branch;
                $q=new CDbCriteria;
                $q->compare('t.company_id',$cmp);
                $branches=$bran->findAll($q);
                $user=new User;
                $q=new CDbCriteria;
                $q->join=' left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id'
                        . ' left join company on company.id=branch.company_id';
                $q->compare('company.id',$cmp);
                if($type_id==23 || $type_id==22)
                  $q->compare('authassignment.itemname',20);
                else if($type_id==30 || $type_id==31)
                    $q->compare('authassignment.itemname',28);
                $supervisors=$user->findAll($q);
                
                 $criteria=new CDbCriteria;
                $criteria->join=' left join authassignment on authassignment.userid=t.id left join branch on branch.id=t.branch_id'
                        . ' left join company on company.id=branch.company_id left join adjstersupervising on'
                        . ' adjstersupervising.adjuster_id=t.id';
                 $criteria->compare('company.id',$cmp);
                 if($type_id==23 || $type_id==22)
                  $criteria->compare('authassignment.itemname',19);
                 else if($type_id==30 || $type_id==31)
                    $criteria->compare('authassignment.itemname',27);
                if($_POST['Adjstersupervising']['superwiser_id']!='')
                    $criteria->compare('adjstersupervising.superwiser_id',$_POST['Adjstersupervising']['superwiser_id']);
                 
                if($_POST['branch']!='')
                    $criteria->compare('t.branch_id',$_POST['branch']);
                $adjuster=new CActiveDataProvider('User', array(
			'criteria'=>$criteria,
		));
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                
		if(isset($_POST['adjstersupervising-grid_c0']) && $_POST['Adjstersupervising']['superwiser_id']!='')
		{
			//$model->attributes=$_POST['Adjstersupervising'];
                        
			//if($model->save())
				//$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
                        'supervisors'=>$supervisors,
                        'adjusters'=>$adjuster,
                        'udetail'=>$udetail,
                        'branches'=>$branches,
		));
	}
        public static function getSupervisor($aid)
        {
            $model=new Adjstersupervising;
            $q=new CDbCriteria;
            $q->compare('t.adjuster_id',$aid);
            $adj=$model->find($q);
             
            if($adj!=null)
                return $adj->superwiser->first_name." ".$adj->superwiser->last_name;
            else {
                return "";
            }
            
        }
                
        /**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Adjstersupervising']))
		{
			$model->attributes=$_POST['Adjstersupervising'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Adjstersupervising');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Adjstersupervising('search');
                $s=new Adjstersupervising;
                $q=new CDbCriteria;
                $q->join="left join user on t.superwiser_id=user.id";
                $q->compare('t.superwiser_id',Yii::app()->user->id);
                $super=$s->findAll($q,array('t.superwiser_id','t.superwiser.username'));
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Adjstersupervising']))
			$model->attributes=$_GET['Adjstersupervising'];

		$this->render('admin',array(
			'model'=>$model,
                        'super'=>$super,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Adjstersupervising the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Adjstersupervising::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Adjstersupervising $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='adjstersupervising-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
