<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'Claims Flow Solutions',
'timeZone' => $_SESSION['time_zone'],
	// preloading 'log' component
	'preload'=>array('log'),

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
		'application.modules.rights.*',
		'application.controllers.*',
		'ext.giix-components.*',
		'application.modules.rights.components.*',
		//'application.extensions.debugtoolbar.*',
		'application.modules.rights.components.dataproviders.*',
		'ext.YiiMailer.YiiMailer',
		'ext.ziplocator.ZipLocator.*',
		 'application.anet_php_sdk.*',
		'application.anet_php_sdk.lib.*',
		'application.anet_php_sdk.lib.shared.*',
		  'ext.ECompositeUniqueValidator.*.*',
	),

	'modules'=>array(
		// uncomment the following to enable the Gii tool
		
		'gii'=>array(
			'class'=>'system.gii.GiiModule',
			'password'=>'123456',
			// If removed, Gii defaults to localhost only. Edit carefully to taste.
			'ipFilters'=>array('127.0.0.1','::1'),
		),
		'rights'=>array(
				'debug'=>true,
				//'install'=>true,
				'enableBizRuleData'=>true,
			),
		
	),

	// application components
	'components'=>array(
		'zip'=>array(
			'class'=>'application.extensions.zip.EZip',
		),
		'localtime'=>array(
			'class'=>'localtime',
			),
			'user'=>array(
                    'class'=>'RWebUser',
                    // enable cookie-based authentication
                    'allowAutoLogin'=>true,
                    'loginUrl'=>array('/site'),
            ),
			'phpmailer' => array(
				'class' => 'application.extensions.phpmailer',
			),
            // uncomment the following to enable URLs in path-format
            'authManager'=>array(
            'class'=>'RDbAuthManager',
            'connectionID'=>'db',
            'itemTable'=>'authitem',
            'itemChildTable'=>'authitemchild',
            'assignmentTable'=>'authassignment',
            'rightsTable'=>'rights',
        ),
		'request'=>array(
			//'enableCsrfValidation'=>true,
		),
		// uncomment the following to enable URLs in path-format
		/*
		'urlManager'=>array(
			'urlFormat'=>'path',
			'rules'=>array(
				'<controller:\w+>/<id:\d+>'=>'<controller>/view',
				'<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
				'<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
			),
		),
		*/
		'db'=>array(
			'connectionString' => 'sqlite:'.dirname(__FILE__).'/../data/testdrive.db',
		),
		// uncomment the following to use a MySQL database
		
		'db'=>array(
			'connectionString' => 'mysql:host=localhost;dbname=claimsfl_cfs',
			'emulatePrepare' => true,
			'username' => 'claimsfl_cfsdev',
			'password' => 'MW^Fd[eAT)MO',
			'charset' => 'utf8',
		),
		'dbadvert'=>array(
			'connectionString' => 'sqlite:protected/data/testdrive.db;dbname=testdrive.db',
                        
		),
		'errorHandler'=>array(
			// use 'site/error' action to display errors
			'errorAction'=>'site/error',
		),
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
				),
				// uncomment the following to show log messages on web pages
				/*
				array(
					'class'=>'CWebLogRoute',
				),
				*/
			),
		),
		 'bsHtml' => array('class' => 'bootstrap.components.BSHtml'),
			'BsHtml' => array('class' => 'bootstrap.components.BSHtml'),
			'chartjs'=>array('class' => 'chartjs.components.ChartJs'),
			'ePdf' => array(
				'class'         => 'ext.yii-pdf.EYiiPdf',
				'params'        => array(
					'mpdf'     => array(
						'librarySourcePath' => 'application.vendors.mpdf.*',
					   'constants'         => array(
							'_MPDF_TEMP_PATH' => Yii::getPathOfAlias('application.runtime'),
						),
					   'class'=>'mpdf', // the literal class filename to be loaded from the vendors folder
						/*'defaultParams'     => array( // More info: http://mpdf1.com/manual/index.php?tid=184
							'mode'              => '', //  This parameter specifies the mode of the new document.
							'format'            => 'A4', // format A4, A5, ...
							'default_font_size' => 0, // Sets the default document font size in points (pt)
							'default_font'      => '', // Sets the default font-family for the new document.
							'mgl'               => 15, // margin_left. Sets the page margins for the new document.
							'mgr'               => 15, // margin_right
							'mgt'               => 16, // margin_top
							'mgb'               => 16, // margin_bottom
							'mgh'               => 9, // margin_header
							'mgf'               => 9, // margin_footer
							'orientation'       => 'P', // landscape or portrait orientation
						)*/
					),
					'HTML2PDF' => array(
							'librarySourcePath' => 'application.vendors.html2pdf.*',
							'classFile'         => 'html2pdf.class.php', // For adding to Yii::$classMap
							'defaultParams'     => array(
								'language'    => 'en', // language: fr, en, it ...
								'encoding'    => 'UTF-8', // charset encoding; Default is UTF-8
						)
						/*'defaultParams'     => array( // More info: http://wiki.spipu.net/doku.php?id=html2pdf:en:v4:accueil
							'orientation' => 'P', // landscape or portrait orientation
							'format'      => 'A4', // format A4, A5, ...
							'language'    => 'en', // language: fr, en, it ...
							'unicode'     => true, // TRUE means clustering the input text IS unicode (default = true)
							'encoding'    => 'UTF-8', // charset encoding; Default is UTF-8
							'marges'      => array(5, 5, 5, 8), // margins by default, in order (left, top, right, bottom)
						)*/
					)
				),
			),
	),

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params'=>array(
		// this is used in contact page
		'adminEmail'=>'admin@claimsflowsolutions.com',
	),
);
?>